// 9/10/2018

load "subgroups.m"; // Sutherland 
load "Equations.txt"; // Zywina

load "../Data_ZD2E.m";

print "Testing the data from Zywina files......";

// Added the commented line that correspond to the constant jmaps (7Ns.3.1, 11B.10.4,11B.10.5,17B.4.2,17B.4.6,37B.8.1,37B.8.2) for testing.
// 13S4 is not defined since there are 3 known j-maps.

Groups["7Ns.3.1"] := rec<grp| level:=7, group:=sub<GL(2,Integers(7)) | {[2,0,0,4], [0,2,1,0],[-1,0,0,-1]}>, jmap := F!3^3*5*7^5/2^7>;

Groups["11B.10.4"] := rec<grp| level:=11, group:=sub<GL(2,Integers(11)) | {[-1,0,0,-1],[1,1,0,1],[4,0,0,6]}>, jmap := F!-11^2>;
Groups["11B.10.5"] := rec<grp| level:=11, group:=sub<GL(2,Integers(11)) | {[-1,0,0,-1],[1,1,0,1],[5,0,0,7]}>, jmap := F!-11*131^3>;

// There are three know j-invariants such that G_E(13)=13S4. Then it is not possible to create Groups["13S4"] in the REC format Groups.
//Groups["13S4"] := rec<grp|level:=13,group:=sub<GL(2,Integers(13)) | {[2,0,0,2], [2,0,0,3], [0,-1,1,0], [1,1,-1,1]}>, jmap:=[ (2^4*5*13^4*17^3)/3^13, -(2^12*5^3*11*13^4)/3^13, (2^18*3^3*13^4*127^3*139^3*157^3*283^3*929)/(5^13*61^13) ]>;

Groups["17B.4.2"] := rec<grp|level:=17,group:=sub<GL(2,Integers(17)) | {[2,0,0,11], [4,0,0,-4], [1,1,0,1]}>,jmap:=F!-17*373^3/2^17>;
Groups["17B.4.6"] := rec<grp|level:=17,group:=sub<GL(2,Integers(17)) | {[11,0,0,2], [-4,0,0,4], [1,1,0,1]}>, jmap:=F!-17^2*101^3/2>;

Groups["37B.8.1"] := rec<grp|level:=37,group:=sub<GL(2,Integers(37)) | {[2^3,0,0,1], [1,0,0,2], [1,1,0,1]}>, jmap:=F!-7*11^3>;
Groups["37B.8.2"] := rec<grp|level:=37,group:=sub<GL(2,Integers(37)) | {[2,0,0,1], [1,0,0,2^3], [1,1,0,1]}>, jmap:=F!-7*137^3*2083^3>;

function Test_SZ_FP(p,GG,JJ)
	case p:
		when 11:
			n:=2; // no 11Nn (see below)
		when 13:
			n:=6; // no 13S4 (see below)
		 else
		n:=#GG;
	end case;	
	
	for i in [1..n] do 
		G:=GG[i];
		Sutherland_label:=GL2SubgroupLabel(G);	
		boo_j:=JJ[i] eq Groups[Sutherland_label]`jmap;
		boo_group:=IsIsomorphic(G,Groups[Sutherland_label]`group);
		if (not boo_j) or (not boo_group) then 
			printf "ERROR ----> %o\n",Sutherland_label; 
			return false;
		end if;
	end for;
	return true;
end function;


/*
for p in [2,3,5,7,11,13,17] do
	printf "boo%o:=Test_SZ_FP(%o,G%o,J%o);\n",p,p,p,p;
end for;
*/
boo2:=Test_SZ_FP(2,G2,J2);
boo3:=Test_SZ_FP(3,G3,J3);
boo5:=Test_SZ_FP(5,G5,J5);
boo7:=Test_SZ_FP(7,G7,J7);
boo11:=Test_SZ_FP(11,G11,J11);
boo13:=Test_SZ_FP(13,G13,J13);
boo17:=Test_SZ_FP(17,G17,J17);

assert &and[boo2,boo2,boo5,boo7,boo11,boo13,boo17];

// There are three know j-invariants such that G_E(13)=13S4. Then it is not possible to create Groups["13S4"] in the REC format Groups.

//"13S4"

group13S4:=sub<GL(2,Integers(13)) | {[2,0,0,2], [2,0,0,3], [0,-1,1,0], [1,1,-1,1]}>;
jmap13S4:=[ (2^4*5*13^4*17^3)/3^13, -(2^12*5^3*11*13^4)/3^13, (2^18*3^3*13^4*127^3*139^3*157^3*283^3*929)/(5^13*61^13) ];

GG:=G13;
i:=7;
G:=GG[i];
J:=J13_7;	
		
Sutherland_label:=GL2SubgroupLabel(G);

assert (Sutherland_label eq "13S4") and (J eq jmap13S4) and IsIsomorphic(G,group13S4);


//"11Nn"
// copy and paste A11,B11,C11. Not neccesary to test

print ".........Everything is OK";



// N.D. Elkies,
// "Elliptic curves with $3$-adic Galois representation surjective mod 3 but not mod 9"
// http://arxiv.org/abs/math/0612734





_<x>:=RationalFunctionField(Rationals());

jElkies1 := - (3^7*(x^2 - 1)^3*(x^6 + 3*x^5 + 6*x^4 + x^3 - 3*x^2 + 12*x + 16)^3*(2*x^3 + 3*x^2 - 3*x - 5))/((x^3 - 3*x - 1)^9);
A := x^6 + 6*x^5 + 4*x^3 + 12*x^2 - 18*x - 23;
B := 7*x^6 + 24*x^5 + 18*x^4 - 26*x^3 - 33*x^2 + 18*x + 28;
jElkies2 := 1728 - (3^3*A^2*B^2*(2*x^3 - 3*x^2 + 4))/((x^3 - 3*x - 1)^9);
assert (jElkies2 - 2*1728) eq jElkies1;
// It seems that there are some typos at Elkies's paper.
 
// L. Mavrides, 
// "Modular curves and surjectivity of Galois representations attached to elliptic curves over Q.
// Master Thesis (University of Warwick) 2011.

/*
 Chapter 5
Conclusion
In this essay we have been successful with the objective been set at the beginning; that is to give a clear exposition of the densely written paper of Elkies [Elkies], expanding on the major tools being used. One of the main reasons this paper has driven the need to do as such, is a possible error in the function
jElkies1
Due to the nature of this paper, spotting where a possible error has occurred was quite not possible. Hence we decided to recalculate everything step by step from the beginning and give a new equation of f(x), that is
jMavrides
As a result, even in the case where we have performed an error in our calculations, spotting the error is now a much easier task.
*/

jMavrides:=-3^7*5*2^(12)*(x - 2)^3*x^3*(x^3 - 12/5*x^2 + 6/5*x -1/5)*(x^6 - 21/4*x^5 + 177/16*x^4 - 187/16*x^3 + 105/16*x^2 - 15/8*x + 1/4)^3/((x^3 - 3*x + 1)^9);

assert Evaluate(jMavrides,(1+x)/x) eq -jElkies1;

print "jMavrides is \"equal\" to -jElkies"; 

quit;
