//8/10/2018

load "Data_ZD2E.m";


function jQ(G)
	assert G in ["7Ns.3.1", "11B.10.4","11B.10.5","13S4","17B.4.2","17B.4.6","37B.8.1","37B.8.2"];
    case G:
    	when "7Ns.3.1":
    		return [3^3*5*7^5/2^7];
    	when "11B.10.4":
    		return [-11^2];
    	when "11B.10.5":
    		return [-11*131^3];
    	 when "13S4":
	    	return [(2^4*5*13^4*17^3)/3^13, -(2^12*5^3*11*13^4)/3^13, (2^18*3^3*13^4*127^3*139^3*157^3*283^3*929)/(5^13*61^13) ];
    	when "17B.4.2":
    	    return [-17*373^3/2^17];
    	when "17B.4.6":   	
	   		return [-17^2*101^3/2];
    	when "37B.8.1":
     		return [-7*11^3];   	
    	when "37B.8.2":
        	return [-7*137^3*2083^3];
    end case;
end function;


function FiberProduct_jQ(g1,g2)
//	R<x>:=PolynomialRing(Rationals());
	if not (g2 in ["7Ns.3.1", "11B.10.4","11B.10.5","13S4","17B.4.2","17B.4.6","37B.8.1","37B.8.2"]) then return false; end if;	
	if g1 ne "11Nn" then
		f:= Groups[g1]`jmap;	
		for jE in jQ(g2) do
			g:=Numerator(f)-Denominator(f)*jE;
    		if #Roots(g) ne 0 then return true; end if;
    	end for;					
	 else 
	 	for jE in jQ(g2) do
			g:=Numerator(A11*jE^2+B11*jE+C11);
			if #Roots(g) ne 0 then return true; end if;
    	end for;;
	end if;

	return false;
end function;


for g1 in Keys(Groups) do
	for g2 in ["7Ns.3.1", "11B.10.4","11B.10.5","13S4","17B.4.2","17B.4.6","37B.8.1","37B.8.2"] do
	   if FiberProduct_jQ(g1,g2) then printf "[%o,%o]\n",g1,g2; end if; 
	end for;	
end for;


        	
