//15/10/2018

load "output_genus0.txt";
load "output_genus1.txt";


s0:= &join{Seqset(c) : c in Genus0_P1};
s1:= &join{Seqset(c) : c in Genus1PosRank};     


S:=s0 join s1;

serre:={Seqset(c) : c in Genus0_P1 } join {Seqset(c) : c in Genus1PosRank };

S3:=Subsets(S,3);

Triples:={ };

for s in S3 do
  if &and{s2 in serre : s2 in Subsets(s,2)} then 
  	Triples:=Triples join {s}; 
  end if;
end for;

/*
> Triples;
{
    { 3Nn, 5S4, 4X7 },
    { 3Nn, 8X5, 5S4 },
    { 3Nn, 5Nn, 8X5 },
    { 3Nn, 5B, 2B }
}
*/
   
    
load "FiberProductsData.m";
load "Data_ZD2E.m";

S:=[Setseq(s) : s in Setseq(Triples)];
for k in S do
	print [<s,FiberProducts[Sort(Setseq(s))]`genus> : s in Subsets(Seqset(S[1]),2)];
	G1:=FiberProducts[[k[1],k[2]]]`group;
	G:=LiftGroups(G1,Groups[k[3]]`group);
	print k,GL2Genus(G); 
end for;

/*
[
    <{ 3Nn, 4X7 }, 0>,
    <{ 3Nn, 5S4 }, 1>,
    <{ 5S4, 4X7 }, 1>
]
[ 3Nn, 5S4, 4X7 ]
4
[
    <{ 3Nn, 4X7 }, 0>,
    <{ 3Nn, 5S4 }, 1>,
    <{ 5S4, 4X7 }, 1>
]
[ 3Nn, 8X5, 5S4 ]
3
[
    <{ 3Nn, 4X7 }, 0>,
    <{ 3Nn, 5S4 }, 1>,
    <{ 5S4, 4X7 }, 1>
]
[ 3Nn, 5Nn, 8X5 ]
5
[
    <{ 3Nn, 4X7 }, 0>,
    <{ 3Nn, 5S4 }, 1>,
    <{ 5S4, 4X7 }, 1>
]
[ 3Nn, 5B, 2B ]
2
*/

//  j-map of 10B

j1:=(t^6-4*t^5+16*t+16)^3/((t+1)^2*(t-4)*t^5);

// 3Nn

j2:=t^3;

// Fiber product corresponding to [2B,5B,3Nn]=[10B,3Nn]

	R<x,y>:=PolynomialRing(Rationals(),2);
	g:=Numerator(Evaluate(j1,x)-Evaluate(j2,y));
	fac := Factorization(g);
	for f in fac do
  			C := ProjectiveClosure(Curve(AffineSpace(R),f[1]));
    		g:=Genus(C);
	end for;

	assert Genus(C) eq 2;
	
	_,H1,mp1 := IsHyperelliptic(C);
	H,mp2 := SimplifiedModel(H1);
/*
	> H;
	Hyperelliptic Curve defined by y^2 = x^6 - 18*x^3 + 1 over Rational Field
	H is the newmodular curve C_{90}^{A,B} from Baker et al Finiteness Results for modular curves of genus at least 2". American Journal of Mathematics 127, no. 6, 1325-1387, (2005).
	That means that Jac(H) is Q-isogenous to the product of the elliptic curves 90a and 90b
*/
	J := Jacobian(H);
	assert RankBound(J) eq 0;
	PtsH := Chabauty0(J); 
	PtsC := { };
	PHI := mp1*mp2;
	for P in PtsH do
		PtsC := {pt : pt in RationalPoints(P @@ PHI)} join PtsC;
	end for;
    J1 := {Evaluate(j1,P[1]) : P in PtsC | Evaluate(Denominator(j1),P[1]) ne 0 and P[3] ne 0};
	J2 := {Evaluate(j2,P[2]) : P in PtsC | Evaluate(Denominator(j2),P[2]) ne 0 and P[3] ne 0};
	assert J1 eq J2;
	assert J1 eq {};




