// Proof that there are not 3 simultaneous exceptional primes 
// Case genus 0 only

// For the case of genus 1 (all of rank 0) we need to have complete the parametrizations


// Maximal subgroups from Theorem 1 such that anyone of them appears always in a fiber product of genus 0
Sg0:={"2B","2Cn","2Cs","3B","3Cs","3Nn","3Ns","5B","5S4","7B"};

// Maximal subgroups from Theorem 1 such that anyone of them appears always in a fiber product of an elliptic curve of genus 1

Sg1_r1:={"3Nn","7Nn","5Ns","5S4"};

S:=Sg0 join Sg1_r1;

// Pairs of maximal groups such that the fiber product of their corresponding modular genus 0 curve has genus 0
serre0:={{"2B","3B"},{"2B","3Cs"},{"2B","3Nn"},{"2B","3Ns"},{"2B","5B"},{"2Cn","3B"},{"2Cn","5S4"},{"2Cn","7B"},{"2Cs","3B"},{"3Nn","5B"}};

serre1_r1:={{"3Nn","7Nn"},{"3Nn","5Nn"},{"3Nn","5Ns"},{"3Nn","5S4"}};

serre:=serre0 join serre1_r1;


S3:=Subsets(S,3);

Triples:={@ @};

for s in S3 do
  if &and{s2 in serre : s2 in Subsets(s,2)} then Triples:=Triples join {s}; end if;
end for;

assert Triples eq {@ { "2B", "3Nn", "5B" } @};




_<t>:=FunctionField(Rationals());

// j-map of [2B,5B]

j1:=(-5/8*t^18 + 780*t^17 - 355200*t^16 + 71045120*t^15 - 6232473600*t^14 + 
    313833553920*t^13 - 10400221364224*t^12 + 244463632908288*t^11 - 
    4260289730052096*t^10 + 56541285946753024*t^9 - 580357421512261632*t^8 + 
    4638848353679966208*t^7 - 144274502912674103296/5*t^6 + 692455464305977982976/5*t^5 
    - 2517980566061353795584/5*t^4 + 6714614842830276788224/5*t^3 - 
    12396212017532818685952/5*t^2 + 14167099448608935641088/5*t - 
    37778931862957161709568/25)/(t^17 - 264/5*t^16 + 29824/25*t^15 - 74752/5*t^14 + 
    561152/5*t^13 - 2523136/5*t^12 + 6291456/5*t^11 - 33554432/25*t^10);

//  j-map of 2B

j1:=256*(t+1)^3/t;

//  j-map of [3Nn,5B]

j2:=(30517578125*t^18 + 7324218750*t^15 + 615234375*t^12 + 20312500*t^9 + 196875*t^6 + 750*t^3 + 1)/t^3;




//  j-map of 10B

j1:=(t^6-4*t^5+16*t+16)^3/((t+1)^2*(t-4)*t^5);

// 3Nn

j2:=t^3;

// Fiber product corresponding to [2B,5B,3Nn]=[10B,3Nn]

	R<x,y>:=PolynomialRing(Rationals(),2);
	g:=Numerator(Evaluate(j1,x)-Evaluate(j2,y));
	fac := Factorization(g);
	for f in fac do
  			C := ProjectiveClosure(Curve(AffineSpace(R),f[1]));
    		g:=Genus(C);
	end for;

	assert Genus(C) eq 2;
	
	_,H1,mp1 := IsHyperelliptic(C);
	H,mp2 := SimplifiedModel(H1);
/*
	> H;
	Hyperelliptic Curve defined by y^2 = x^6 - 18*x^3 + 1 over Rational Field
	H is the newmodular curve C_{90}^{A,B} from Baker et al Finiteness Results for modular curves of genus at least 2". American Journal of Mathematics 127, no. 6, 1325-1387, (2005).
	That means that Jac(H) is Q-isogenous to the product of the elliptic curves 90a and 90b
*/
	J := Jacobian(H);
	assert RankBound(J) eq 0;
	PtsH := Chabauty0(J); 
	PtsC := { };
	PHI := mp1*mp2;
	for P in PtsH do
		PtsC := {pt : pt in RationalPoints(P @@ PHI)} join PtsC;
	end for;
    J1 := {Evaluate(j1,P[1]) : P in PtsC | Evaluate(Denominator(j1),P[1]) ne 0 and P[3] ne 0};
	J2 := {Evaluate(j2,P[2]) : P in PtsC | Evaluate(Denominator(j2),P[2]) ne 0 and P[3] ne 0};
	assert J1 eq J2;
	assert J1 eq {};


